/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PAManualSelectEventLogFieldPanel
extends JPanel
implements IVWTaskWizardPanel,
IVWTaskWizardControl,
KeyListener {
    PADataFieldWizard m_wizard = null;
    PADataFieldsNode m_node = null;
    JTextField m_fieldEdit = null;
    JComboBox m_fieldType = null;
    JTextField m_uniqueName = null;
    private static final int MAX_FIELD_NAME_LENGTH = 128;

    public PAManualSelectEventLogFieldPanel(PADataFieldWizard dataFieldWizard) throws Exception {
        this.m_wizard = dataFieldWizard;
        this.m_node = dataFieldWizard.getDataFieldsNode();
        this.initLayout();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(this.getPEFieldPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(20, 0, 0, 0);
        this.add(this.getUniqueNamePanel(), c);
    }

    private Component getPEFieldPanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.CEPEEventLogField, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.Field)), c);
        this.m_fieldEdit = new JTextField();
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_fieldEdit, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.FieldType)), c);
        this.m_fieldType = new JComboBox();
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_fieldType, c);
        this.m_fieldType.addItem("String");
        this.m_fieldType.addItem("Integer");
        this.m_fieldType.addItem("Boolean");
        this.m_fieldType.addItem("Time");
        this.m_fieldType.addItem("Float");
        this.m_fieldType.addItem("Guid");
        return borderPanel;
    }

    protected int getFieldTypeAsInt() {
        String fieldType = this.m_fieldType.getSelectedItem().toString();
        if (fieldType == null) {
            return -1;
        }
        if (fieldType.equals("Integer")) {
            return 1;
        }
        if (fieldType.equals("String") || fieldType.equals("")) {
            return 2;
        }
        if (fieldType.equals("Boolean")) {
            return 4;
        }
        if (fieldType.equals("Float")) {
            return 8;
        }
        if (fieldType.equals("Time")) {
            return 16;
        }
        if (fieldType.equals("Guid")) {
            return 512;
        }
        return -1;
    }

    private Component getUniqueNamePanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessAnalyzerUniqueName, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.UniqueName)), c);
        this.m_uniqueName = new JTextField();
        this.m_uniqueName.addKeyListener(this);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_uniqueName, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        return borderPanel;
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public String getInstructions() {
        return VWResource.SelectManualField;
    }

    public void performValidation() throws Exception {
        String uniqueName = this.getUniqueName();
        if (uniqueName.equals("")) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.UniqueNameMustBeSpecified", "A unique name must be specified.");
        }
        if (!(!this.m_wizard.isNewDataField() && uniqueName.equals(this.m_wizard.getDataFieldNode().getName()) || this.m_node.isNameUnique(uniqueName))) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.NameIsNotUnique", "The name \"{0}\" has already been used.  Enter a unique name.", uniqueName);
        }
        if (uniqueName.length() > 128) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.UniqueNameToLong", "The maximun length for a unique name is {0} characters.", new Integer(128));
        }
        boolean bValidName = true;
        if (!Character.isLetter(uniqueName.charAt(0))) {
            bValidName = false;
        } else {
            for (int i = 0; i < uniqueName.length(); ++i) {
                if (Character.isLetterOrDigit(uniqueName.charAt(i)) || uniqueName.charAt(i) == '_') continue;
                bValidName = false;
            }
        }
        if (!bValidName) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.InvalidUniqueNameSyntax", "The unique name must begin with a letter and contain only letters, numbers, or underscores.");
        }
        if (this.isReservedWord(uniqueName)) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.CannotUseReservedWord", "The term ''{0}'' is reserved for Case Analyzer internal use and cannot be used as the unique name of a data field.", uniqueName);
        }
    }

    public void refresh() {
    }

    public boolean allowButtonToBeEnabled(int button) {
        if (button == 1) {
            return this.getUniqueName().length() > 0 && this.getFieldName().length() > 0 && this.getFieldType().length() > 0;
        }
        return true;
    }

    public String getFieldName() {
        return this.m_fieldEdit.getText().trim();
    }

    public String getFieldType() {
        return this.m_fieldType.getSelectedItem().toString();
    }

    public String getUniqueName() {
        return this.m_uniqueName.getText().trim();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.m_wizard != null) {
            this.m_wizard.updateButtonState();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean skipThisPanel() {
        return !this.m_wizard.IsSourceManualSelected();
    }

    private boolean isReservedWord(String word) {
        if (word.equalsIgnoreCase("Queue")) {
            return true;
        }
        if (word.equalsIgnoreCase("Status")) {
            return true;
        }
        if (word.equalsIgnoreCase("User")) {
            return true;
        }
        if (word.equalsIgnoreCase("Workflow")) {
            return true;
        }
        if (word.equalsIgnoreCase("Time")) {
            return true;
        }
        if (word.equalsIgnoreCase("Incoming")) {
            return true;
        }
        if (word.equalsIgnoreCase("Outgoing")) {
            return true;
        }
        return word.equalsIgnoreCase("Workload");
    }
}

